/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.Standards;
import com.quantumdata.sct.dao.jaxb.Test;
import com.quantumdata.sct.dao.jaxb.Tests;
import com.quantumdata.sct.dao.jaxb.impl.TestImpl;
import com.quantumdata.sct.dao.jaxb.impl.TestsImpl;
import com.quantumdata.sct.dao.jaxb.impl.TestsTypeImpl;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.Iterator;

public class TestDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            Tests tests = (Tests)this.daoObject;
            int n = tests.getTestsCollection().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                TestsTypeImpl.TestImpl testImpl = (TestsTypeImpl.TestImpl)((Tests)this.daoObject).getTestsCollection().get(i);
                this.daoCollection.put(testImpl.getId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            return this.findByPrimaryKey((String)object);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((TestsImpl)this.daoObject).getTestsCollection().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            TestsTypeImpl.TestImpl testImpl = (TestsTypeImpl.TestImpl)((Tests)this.daoObject).getTestsCollection().get(i);
            iPersistableArray[i] = this.createPersistable(testImpl);
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof Test) {
            Test test = (Test)object;
            object2 = test.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) throws Exception {
        TestVO testVO = new TestVO();
        if (object instanceof TestsTypeImpl.TestImpl) {
            this.copyFrom((TestsTypeImpl.TestImpl)object, testVO);
        }
        return testVO;
    }

    protected void copyFrom(TestsTypeImpl.TestImpl testImpl, TestVO testVO) throws Exception {
        testVO.setId(testImpl.getId());
        testVO.setRepeatable(testImpl.isRepeatable());
        testVO.setImageRef(testImpl.getImageLocation());
        testVO.setLastUpdate(testImpl.getLastUpdateTime());
        testVO.setDescription(testImpl.getDescription());
        testVO.setComplainceSectionId(testImpl.getComplainceSectionId());
        for (TestImpl.StepIdImpl stepIdImpl : testImpl.getSteps()) {
            testVO.addStepId(stepIdImpl.getValue());
        }
    }

    protected void copyTo(TestsTypeImpl.TestImpl testImpl, TestVO testVO) throws Exception {
        testImpl.setId((String)testVO.getId());
        testImpl.setRepeatable(testVO.isRepeatable());
        testImpl.setImageLocation(testVO.getImageRef());
        testImpl.setLastUpdateTime(testVO.getLastUpdate());
        testImpl.setDescription(testVO.getDescription());
        testImpl.setComplainceSectionId(testVO.getComplainceSectionId());
        Iterator iterator = testVO.getStepIds().iterator();
        while (iterator.hasNext()) {
            TestImpl.StepIdImpl stepIdImpl = (TestImpl.StepIdImpl)this.factory.createTestStepId((String)iterator.next());
            testImpl.getSteps().add(stepIdImpl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void update(IPersistable iPersistable) throws UpdateException {
        if (!(iPersistable instanceof TestVO)) throw new UpdateException("Invalid Object", null);
        try {
            TestVO testVO = (TestVO)iPersistable;
            if (!this.daoCollection.containsKey(testVO.getId()) || !testVO.isDirty()) return;
            Object v = this.daoCollection.get(testVO.getId());
            System.out.println(v.getClass().getName());
            Integer n = (Integer)this.daoCollection.get(testVO.getId());
            TestsTypeImpl.TestImpl testImpl = (TestsTypeImpl.TestImpl)((Tests)this.daoObject).getTestsCollection().get(n);
            this.copyTo(testImpl, testVO);
            return;
        }
        catch (Exception exception) {
            throw new UpdateException(exception.getMessage(), null, exception);
        }
    }

    protected void updateObject(IPersistable iPersistable) throws Exception {
        if (this.daoCollection.containsKey(iPersistable.getId())) {
            Integer n = (Integer)this.daoCollection.get(iPersistable.getId());
            TestsTypeImpl.TestImpl testImpl = (TestsTypeImpl.TestImpl)((Tests)this.daoObject).getTestsCollection().get(n);
            this.copyTo(testImpl, (TestVO)iPersistable);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) throws Exception {
        TestVO testVO = null;
        if (this.daoCollection.containsKey(string)) {
            Integer n = (Integer)this.daoCollection.get(string);
            TestsTypeImpl.TestImpl testImpl = (TestsTypeImpl.TestImpl)((Tests)this.daoObject).getTestsCollection().get(n);
            TestVO testVO2 = new TestVO();
            this.copyFrom(testImpl, testVO2);
            testVO = testVO2;
        }
        return testVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((Standards)this.daoObject).getStandardsCollection().remove(n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            int n2 = ((Tests)this.daoObject).getTestsCollection().size();
            if (!(iPersistable instanceof TestVO) || n >= n2) {
                throw new Exception("Invalid parameters being passed");
            }
            TestsTypeImpl.TestImpl testImpl = (TestsTypeImpl.TestImpl)this.factory.createTestsTypeTest();
            this.copyTo(testImpl, (TestVO)iPersistable);
            ((Tests)this.daoObject).getTestsCollection().add(n, testImpl);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (!(iPersistable instanceof TestVO)) {
                throw new Exception("Invalid Value Object being passed");
            }
            TestsTypeImpl.TestImpl testImpl = (TestsTypeImpl.TestImpl)this.factory.createTestsTypeTest();
            this.copyTo(testImpl, (TestVO)iPersistable);
            ((TestsTypeImpl)this.daoObject).getTestsCollection().add(testImpl);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

